-- Generated by tools/imgui_upgrader/build_enums.lua

local ImGuiDragDropFlags_None                     = 0
local ImGuiDragDropFlags_SourceNoPreviewTooltip   = 1    -- 1 << 0
local ImGuiDragDropFlags_SourceNoDisableHover     = 2    -- 1 << 1
local ImGuiDragDropFlags_SourceNoHoldToOpenOthers = 4    -- 1 << 2
local ImGuiDragDropFlags_SourceAllowNullID        = 8    -- 1 << 3
local ImGuiDragDropFlags_SourceExtern             = 16   -- 1 << 4
local ImGuiDragDropFlags_SourceAutoExpirePayload  = 32   -- 1 << 5
local ImGuiDragDropFlags_AcceptBeforeDelivery     = 1024 -- 1 << 10
local ImGuiDragDropFlags_AcceptNoDrawDefaultRect  = 2048 -- 1 << 11
local ImGuiDragDropFlags_AcceptPeekOnly           = 3072 -- ImGuiDragDropFlags_AcceptBeforeDelivery | ImGuiDragDropFlags_AcceptNoDrawDefaultRect
local ImGuiDragDropFlags_AcceptNoPreviewTooltip   = 4096 -- 1 << 12

imgui.DragDropFlags = {
	None                     = ImGuiDragDropFlags_None,
	SourceNoPreviewTooltip   = ImGuiDragDropFlags_SourceNoPreviewTooltip,   -- Disable preview tooltip. By default, a successful call to BeginDragDropSource opens a tooltip so you can display a preview or description of the source contents. This flag disables this behavior.
	SourceNoDisableHover     = ImGuiDragDropFlags_SourceNoDisableHover,     -- By default, when dragging we clear data so that IsItemHovered() will return false, to avoid subsequent user code submitting tooltips. This flag disables this behavior so you can still call IsItemHovered() on the source item.
	SourceNoHoldToOpenOthers = ImGuiDragDropFlags_SourceNoHoldToOpenOthers, -- Disable the behavior that allows to open tree nodes and collapsing header by holding over them while dragging a source item.
	SourceAllowNullID        = ImGuiDragDropFlags_SourceAllowNullID,        -- Allow items such as Text(), Image() that have no unique identifier to be used as drag source, by manufacturing a temporary identifier based on their window-relative position. This is extremely unusual within the dear imgui ecosystem and so we made it explicit.
	SourceExtern             = ImGuiDragDropFlags_SourceExtern,             -- External source (from outside of dear imgui), won't attempt to read current item/window info. Will always return true. Only one Extern source can be active simultaneously.
	SourceAutoExpirePayload  = ImGuiDragDropFlags_SourceAutoExpirePayload,  -- Automatically expire the payload if the source cease to be submitted (otherwise payloads are persisting while being dragged)
	AcceptBeforeDelivery     = ImGuiDragDropFlags_AcceptBeforeDelivery,     -- AcceptDragDropPayload() will returns true even before the mouse button is released. You can then call IsDelivery() to test if the payload needs to be delivered.
	AcceptNoDrawDefaultRect  = ImGuiDragDropFlags_AcceptNoDrawDefaultRect,  -- Do not draw the default highlight rectangle when hovering over target.
	AcceptPeekOnly           = ImGuiDragDropFlags_AcceptPeekOnly,           -- For peeking ahead and inspecting the payload before delivery.
	AcceptNoPreviewTooltip   = ImGuiDragDropFlags_AcceptNoPreviewTooltip,   -- Request hiding the BeginDragDropSource tooltip from the BeginDragDropTarget site.
}
